string GetDescription()
{
	return "This is an advanced piano arrangement in the style of swinging blues - best used with songs in major mode.";
}

void Arrange(Song @s)
{
	int bars = s.GetBars();
	
	s.AddTrack("Melody", RndInt(2,4),127,64);
	s.AddTrack("Alt Mel", RndInt(2,4),127,64);
	s.AddTrack("Acc", RndInt(1,4),127,64);
	s.AddTrack("Bass", RndInt(1,4),127,64);
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			
			s.AddRenderEvent("Random Bass", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1); 
		}	
		
		if (s.GetPart(i).GetArrHint() == 1)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1); 
			
			s.AddRenderEvent("Random Bass", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1); 
		}	
		
		if (s.GetPart(i).GetArrHint() == 2)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1); 
			
			s.AddRenderEvent("Random Bass", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1); 
		}	
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			s.AddRenderEvent("Chordal Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1); 
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 3, CreateTime(0,0),0.8); 
			s.AddRenderEvent("Swinging Blues", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i)-1, 1, CreateTime(0,0),0.75); 				
			s.AddRenderEvent("Random Bass", 1, 3, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1); 
		}	
	}
	
	s.AddRenderEvent("Swinging Blues", RndInt(0,32000), 2, s.GetPartEndBar(0)-1, s.GetPartEndBar(0), 0, CreateTime(-(s.GetPartEndBar(0)-s.GetPartStartBar(0)),0),0.5); 	
	s.AddRenderEvent("Swinging Blues", RndInt(0,32000), 2, 0, bars-1, 0, CreateTime(0,0),0.8); 
	s.AddRenderEvent("Simple Chords", RndInt(0,32000), 2, bars-1, bars, 0, CreateTime(0,0),1); 
}